#ifndef __PNIO_APCTL_ERROR_H
#define __PNIO_APCTL_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// PNIO APCTL Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_PNIO_APCTL_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command.
//
#define TLR_E_PNIO_APCTL_COMMAND_INVALID ((TLR_RESULT)0xC00C0001L)

//
// MessageId: TLR_E_PNIO_APCTL_RSC_OUTOFMEMORY
//
// MessageText:
//
//  Unsufficient memory to handle the request.
//
#define TLR_E_PNIO_APCTL_RSC_OUTOFMEMORY ((TLR_RESULT)0xC00C0002L)

//
// MessageId: TLR_E_PNIO_APCTL_HIF_IDENT
//
// MessageText:
//
//  Error indetifying HIF.
//
#define TLR_E_PNIO_APCTL_HIF_IDENT       ((TLR_RESULT)0xC00C0003L)

//
// MessageId: TLR_E_PNIO_APCTL_AREA_IDENT
//
// MessageText:
//
//  Unable to identify requested DPM Channel.
//
#define TLR_E_PNIO_APCTL_AREA_IDENT      ((TLR_RESULT)0xC00C0004L)

//
// MessageId: TLR_E_PNIO_APCTL_GETAREA_IDENT
//
// MessageText:
//
//  Unable to identify DPM section "STD INPUT".
//
#define TLR_E_PNIO_APCTL_GETAREA_IDENT   ((TLR_RESULT)0xC00C0005L)

//
// MessageId: TLR_E_PNIO_APCTL_SETAREA_IDENT
//
// MessageText:
//
//  Unable to identify DPM section "STD OUTPUT".
//
#define TLR_E_PNIO_APCTL_SETAREA_IDENT   ((TLR_RESULT)0xC00C0006L)

//
// MessageId: TLR_E_PNIO_APCTL_SETAREA_INFO_GET
//
// MessageText:
//
//  Unable to get configuration for DPM section "STD OUTPUT".
//
#define TLR_E_PNIO_APCTL_SETAREA_INFO_GET ((TLR_RESULT)0xC00C0007L)

//
// MessageId: TLR_E_PNIO_APCTL_TOHOST_MBX_NAME_GET
//
// MessageText:
//
//  Unable to identify DPM section "TOHOST MBX".
//
#define TLR_E_PNIO_APCTL_TOHOST_MBX_NAME_GET ((TLR_RESULT)0xC00C0008L)

//
// MessageId: TLR_E_PNIO_APCTL_TOHOST_MBX_INFO_GET
//
// MessageText:
//
//  Unable to get configuration for DPM section "TOHOST MBX".
//
#define TLR_E_PNIO_APCTL_TOHOST_MBX_INFO_GET ((TLR_RESULT)0xC00C0009L)

//
// MessageId: TLR_E_PNIO_APCTL_MIDSYS_QUE_IDENT
//
// MessageText:
//
//  Unable to identify queue to MidSys.
//
#define TLR_E_PNIO_APCTL_MIDSYS_QUE_IDENT ((TLR_RESULT)0xC00C000AL)

//
// MessageId: TLR_E_PNIO_APCTL_ENABLE_BUSON_CBK
//
// MessageText:
//
//  Enabling callback function for ApplicationCOS.BUS_ON bit did not succeed.
//
#define TLR_E_PNIO_APCTL_ENABLE_BUSON_CBK ((TLR_RESULT)0xC00C000BL)

//
// MessageId: TLR_E_PNIO_APCTL_ENABLE_APPREADY_CBK
//
// MessageText:
//
//  Enabling callback function for ApplicationCOS.APP_READY bit did not succeed.
//
#define TLR_E_PNIO_APCTL_ENABLE_APPREADY_CBK ((TLR_RESULT)0xC00C000CL)

//
// MessageId: TLR_E_PNIO_APCTL_COMMONAREA_IDENT
//
// MessageText:
//
//  Unable to identify DPM section "COMMON STATUS".
//
#define TLR_E_PNIO_APCTL_COMMONAREA_IDENT ((TLR_RESULT)0xC00C000DL)

//
// MessageId: TLR_E_PNIO_APCTL_STATUSAREA_IDENT
//
// MessageText:
//
//  Unable to identify DPM section "EXTENDED STATUS".
//
#define TLR_E_PNIO_APCTL_STATUSAREA_IDENT ((TLR_RESULT)0xC00C000EL)

//
// MessageId: TLR_E_PNIO_APCTL_CONTROLAREA_IDENT
//
// MessageText:
//
//  Unable to identify DPM section "CONTROL".
//
#define TLR_E_PNIO_APCTL_CONTROLAREA_IDENT ((TLR_RESULT)0xC00C000FL)

//
// MessageId: TLR_E_PNIO_APCTL_GETAREA_INT_ENBL
//
// MessageText:
//
//  Unable to enable DPM section "STD INPUT".
//
#define TLR_E_PNIO_APCTL_GETAREA_INT_ENBL ((TLR_RESULT)0xC00C0010L)

//
// MessageId: TLR_E_PNIO_APCTL_SETAREA_INT_ENBL
//
// MessageText:
//
//  Unable to enable DPM section "STD OUTPUT".
//
#define TLR_E_PNIO_APCTL_SETAREA_INT_ENBL ((TLR_RESULT)0xC00C0011L)

//
// MessageId: TLR_E_PNIO_APCTL_ENABLE_INIT_CBK
//
// MessageText:
//
//  Enabling callback function for ApplicationCOS.INITIALIZATION bit did not succeed.
//
#define TLR_E_PNIO_APCTL_ENABLE_INIT_CBK ((TLR_RESULT)0xC00C0012L)

//
// MessageId: TLR_E_PNIO_APCTL_VOL_IDENT
//
// MessageText:
//
//  Unable to identify SysVolume.
//
#define TLR_E_PNIO_APCTL_VOL_IDENT       ((TLR_RESULT)0xC00C0013L)

//
// MessageId: TLR_E_PNIO_APCTL_VOL_MOUNT
//
// MessageText:
//
//  Unable to mount SysVolume
//
#define TLR_E_PNIO_APCTL_VOL_MOUNT       ((TLR_RESULT)0xC00C0014L)

//
// MessageId: TLR_E_PNIO_APCTL_FAT_FRMT
//
// MessageText:
//
//  Unable to format SysVolume.
//
#define TLR_E_PNIO_APCTL_FAT_FRMT        ((TLR_RESULT)0xC00C0015L)

//
// MessageId: TLR_E_PNIO_APCTL_QUE_CREATE
//
// MessageText:
//
//  The Queue for APCTL task could not be created.
//
#define TLR_E_PNIO_APCTL_QUE_CREATE      ((TLR_RESULT)0xC00C0016L)

//
// MessageId: TLR_E_PNIO_APCTL_CMCTL_QUE_IDENT
//
// MessageText:
//
//  The Queue for CMCTL task could not be identified.
//
#define TLR_E_PNIO_APCTL_CMCTL_QUE_IDENT ((TLR_RESULT)0xC00C0017L)

//
// MessageId: TLR_E_PNIO_APCTL_MGT_QUE_IDENT
//
// MessageText:
//
//  The Queue for MGT task could not be identified.
//
#define TLR_E_PNIO_APCTL_MGT_QUE_IDENT   ((TLR_RESULT)0xC00C0018L)

//
// MessageId: TLR_E_PNIO_APCTL_ACP_QUE_IDENT
//
// MessageText:
//
//  The Queue for ACP task could not be identified.
//
#define TLR_E_PNIO_APCTL_ACP_QUE_IDENT   ((TLR_RESULT)0xC00C0019L)

//
// MessageId: TLR_E_PNIO_APCTL_GETAREA_INFO_GET
//
// MessageText:
//
//  Unable to get configuration for DPM section "STD INPUT".
//
#define TLR_E_PNIO_APCTL_GETAREA_INFO_GET ((TLR_RESULT)0xC00C001AL)

//
// MessageId: TLR_E_PNIO_APCTL_CLR_PCK_GET
//
// MessageText:
//
//  Unable to get a free packet from packet pool to unregister DPM channel from rcX.
//
#define TLR_E_PNIO_APCTL_CLR_PCK_GET     ((TLR_RESULT)0xC00C001BL)

//
// MessageId: TLR_E_PNIO_APCTL_SET_PCK_GET
//
// MessageText:
//
//  Unable to get a free packet from packet pool to register DPM channel from rcX.
//
#define TLR_E_PNIO_APCTL_SET_PCK_GET     ((TLR_RESULT)0xC00C001CL)

//
// MessageId: TLR_E_PNIO_APCTL_IDENT_QUE_MIDSYS
//
// MessageText:
//
//  The Queue of rcX MidSys task could not be identified.
//
#define TLR_E_PNIO_APCTL_IDENT_QUE_MIDSYS ((TLR_RESULT)0xC00C001DL)

//
// MessageId: TLR_E_PNIO_APCTL_CREATE_TIMER_SET
//
// MessageText:
//
//  The timer for firmware-controlled handling of IO-data in DPM could not be created.
//
#define TLR_E_PNIO_APCTL_CREATE_TIMER_SET ((TLR_RESULT)0xC00C001EL)

//
// MessageId: TLR_E_PNIO_APCTL_MEMALLOC_TIMER_SET
//
// MessageText:
//
//  Not enough free memory available for firmware-controlled handling of IO-data in DPM.
//
#define TLR_E_PNIO_APCTL_MEMALLOC_TIMER_SET ((TLR_RESULT)0xC00C001FL)

//
// MessageId: TLR_E_PNIO_APCTL_WDG_INIT
//
// MessageText:
//
//  The Watchdog timer could not be initialized.
//
#define TLR_E_PNIO_APCTL_WDG_INIT        ((TLR_RESULT)0xC00C0020L)

//
// MessageId: TLR_E_INFO_FIELD_ONE_CREATE_FAILED
//
// MessageText:
//
//  The field for extended APCTL task status information could not be created.
//
#define TLR_E_INFO_FIELD_ONE_CREATE_FAILED ((TLR_RESULT)0xC00C0021L)

//
// MessageId: TLR_E_INFO_FIELD_TWO_CREATE_FAILED
//
// MessageText:
//
//  An undefined field could not be created (unused).
//
#define TLR_E_INFO_FIELD_TWO_CREATE_FAILED ((TLR_RESULT)0xC00C0022L)

//
// MessageId: TLR_E_PNIO_APCTL_POOL_CREATE
//
// MessageText:
//
//  The packet pool for APCTL task could not be created.
//
#define TLR_E_PNIO_APCTL_POOL_CREATE     ((TLR_RESULT)0xC00C0023L)

//
// MessageId: TLR_E_PNIO_APCTL_IOCR_LIST
//
// MessageText:
//
//  The number of the input IOCRs is not equal to the number of the output IOCRs.
//
#define TLR_E_PNIO_APCTL_IOCR_LIST       ((TLR_RESULT)0xC00C0024L)

//
// MessageId: TLR_E_PNIO_APCTL_DPM
//
// MessageText:
//
//  The requested function is not supported because DPM is not initialized.
//
#define TLR_E_PNIO_APCTL_DPM             ((TLR_RESULT)0xC00C0025L)

//
// MessageId: TLR_E_PNIO_APCTL_ENABLE_LOCKCONFIG_CBK
//
// MessageText:
//
//  Enabling callback function for ApplicationCOS.LOCK_CONFIGURATION bit did not succeed.
//
#define TLR_E_PNIO_APCTL_ENABLE_LOCKCONFIG_CBK ((TLR_RESULT)0xC00C0026L)

//
// MessageId: TLR_E_PNIO_APCTL_LED_CREATE
//
// MessageText:
//
//  The LEDs could not be initialized.
//
#define TLR_E_PNIO_APCTL_LED_CREATE      ((TLR_RESULT)0xC00C0027L)

//
// MessageId: TLR_E_PNIO_APCTL_ENABLE_DMA_CBK
//
// MessageText:
//
//  Enabling callback function to enable DMA mode did not succeed.
//
#define TLR_E_PNIO_APCTL_ENABLE_DMA_CBK  ((TLR_RESULT)0xC00C0028L)

// The following codes are used by Benjamin
//
// MessageId: TLR_E_PNIO_APCTL_RPC_REQUEST_LIMIT_REACHED
//
// MessageText:
//
//  Too many outstanding RPC-requests for this IO-Device.
//
#define TLR_E_PNIO_APCTL_RPC_REQUEST_LIMIT_REACHED ((TLR_RESULT)0xC00C0030L)

//
// MessageId: TLR_E_PNIO_APCTL_PACKET_SEND_FAILED
//
// MessageText:
//
//  Error while sending internal message to another task.
//
#define TLR_E_PNIO_APCTL_PACKET_SEND_FAILED ((TLR_RESULT)0xC00C0031L)

//
// MessageId: TLR_E_PNIO_APCTL_INVALID_CMCTL_HANDLE
//
// MessageText:
//
//  The handle used for IO-Device is wrong.
//
#define TLR_E_PNIO_APCTL_INVALID_CMCTL_HANDLE ((TLR_RESULT)0xC00C0032L)

//
// MessageId: TLR_E_PNIO_APCTL_INVALID_NAME_OF_STATION_LENGTH
//
// MessageText:
//
//  The name to be set has incorrect length.
//
#define TLR_E_PNIO_APCTL_INVALID_NAME_OF_STATION_LENGTH ((TLR_RESULT)0xC00C0033L)

//
// MessageId: TLR_E_PNIO_APCTL_DCP_REQUEST_LIMIT_REACHED
//
// MessageText:
//
//  Too many outstanding DCP-requests for this IO-Device.
//
#define TLR_E_PNIO_APCTL_DCP_REQUEST_LIMIT_REACHED ((TLR_RESULT)0xC00C0034L)

//
// MessageId: TLR_E_PNIO_APCTL_OTHER_CONFIG_PACKET_IN_PROCESS
//
// MessageText:
//
//  An other configuration packet is in process wait for its confimation packet.
//
#define TLR_E_PNIO_APCTL_OTHER_CONFIG_PACKET_IN_PROCESS ((TLR_RESULT)0xC00C0035L)

//
// MessageId: TLR_E_PNIO_APCTL_APCFG_QUE_IDENT
//
// MessageText:
//
//  Identification of APCFG queue in remote resources failed.
//
#define TLR_E_PNIO_APCTL_APCFG_QUE_IDENT ((TLR_RESULT)0xC00C0036L)

//
// MessageId: TLR_E_PNIO_APCTL_UNKNOWN_ALARM_SPECIFIER
//
// MessageText:
//
//  The Alarmspecifier is unknown to IO-Controller.
//
#define TLR_E_PNIO_APCTL_UNKNOWN_ALARM_SPECIFIER ((TLR_RESULT)0xC00C0037L)

//
// MessageId: TLR_E_PNIO_APCTL_DCP_REQUEST_NO_ANSWER
//
// MessageText:
//
//  The requested IO-Device did not answer to the DCP-requests.
//
#define TLR_E_PNIO_APCTL_DCP_REQUEST_NO_ANSWER ((TLR_RESULT)0xC00C0038L)

//
// MessageId: TLR_E_PNIO_APCTL_APPLICATION_ALREADY_REGISTERED
//
// MessageText:
//
//  There is alredy an Application registered to APCTL-Task.
//
#define TLR_E_PNIO_APCTL_APPLICATION_ALREADY_REGISTERED ((TLR_RESULT)0xC00C0040L)

//
// MessageId: TLR_E_PNIO_APCTL_NO_APPLICATION_REGISTERED
//
// MessageText:
//
//  There is no Application registered to APCTL-Task.
//
#define TLR_E_PNIO_APCTL_NO_APPLICATION_REGISTERED ((TLR_RESULT)0xC00C0041L)

//
// MessageId: TLR_E_PNIO_APCTL_UNREGISTER_APPLICATION_IMPOSSIBLE
//
// MessageText:
//
//  It is impossible to unregister the Application in APCTL-Task. Either there is no Application registered or the Unregister Request was not send by the registered Application.
//
#define TLR_E_PNIO_APCTL_UNREGISTER_APPLICATION_IMPOSSIBLE ((TLR_RESULT)0xC00C0042L)

//
// MessageId: TLR_E_PNIO_APCTL_CHANNEL_INIT_REQUESTED
//
// MessageText:
//
//  The request is rejected because a Channel Init was requested.
//
#define TLR_E_PNIO_APCTL_CHANNEL_INIT_REQUESTED ((TLR_RESULT)0xC00C0050L)

//
// MessageId: TLR_E_PNIO_APCTL_BUS_STATE_OFF
//
// MessageText:
//
//  The request is rejected because bus state is set OFF or a running request was interrupted by setting bus state to OFF.
//
#define TLR_E_PNIO_APCTL_BUS_STATE_OFF   ((TLR_RESULT)0xC00C0051L)

//
// MessageId: TLR_E_PNIO_APCTL_CYCLIC_WATCHDOG_ERROR
//
// MessageText:
//
//  The connection to an IO-Device was closed because too many cyclic frames were missing.
//
#define TLR_E_PNIO_APCTL_CYCLIC_WATCHDOG_ERROR ((TLR_RESULT)0xC00C0052L)

//
// MessageId: TLR_E_PNIO_APCTL_CONNECTION_CLOSED_BY_IODEVICE
//
// MessageText:
//
//  The connection was shutdown by an IO-Device.
//
#define TLR_E_PNIO_APCTL_CONNECTION_CLOSED_BY_IODEVICE ((TLR_RESULT)0xC00C0053L)

//
// MessageId: TLR_E_PNIO_APCTL_WATCHDOG_TIME_TOO_SMALL
//
// MessageText:
//
//  The watchdog time specified is too small.
//
#define TLR_E_PNIO_APCTL_WATCHDOG_TIME_TOO_SMALL ((TLR_RESULT)0xC00C0054L)

//
// MessageId: TLR_E_PNIO_APCTL_WATCHDOG_TIME_TOO_BIG
//
// MessageText:
//
//  The watchdog time specified is too big.
//
#define TLR_E_PNIO_APCTL_WATCHDOG_TIME_TOO_BIG ((TLR_RESULT)0xC00C0055L)

//
// MessageId: TLR_E_PNIO_APCTL_IO_DEVICE_NOT_IN_DATAEXCHANGE
//
// MessageText:
//
//  The service is unavailable because the IO-Device is not in cyclic data exchange.
//
#define TLR_E_PNIO_APCTL_IO_DEVICE_NOT_IN_DATAEXCHANGE ((TLR_RESULT)0xC00C0056L)

//
// MessageId: TLR_E_PNIO_APCTL_ACYCLIC_REQ_FAILED_REMOTE
//
// MessageText:
//
//  The acyclic service failed. The IO-Device answered with an error code which is contained in confirmation packet.
//
#define TLR_E_PNIO_APCTL_ACYCLIC_REQ_FAILED_REMOTE ((TLR_RESULT)0xC00C0060L)

//
// MessageId: TLR_E_PNIO_APCTL_ACYCLIC_REQ_FAILED_RPC
//
// MessageText:
//
//  The acyclic service failed. The RPC-layer detected an error which is contained in confirmation packet.
//
#define TLR_E_PNIO_APCTL_ACYCLIC_REQ_FAILED_RPC ((TLR_RESULT)0xC00C0061L)

//
// MessageId: TLR_E_PNIO_APCTL_ACYCLIC_REQ_FAILED_INTERNAL
//
// MessageText:
//
//  The acyclic service failed. An internal error occured.
//
#define TLR_E_PNIO_APCTL_ACYCLIC_REQ_FAILED_INTERNAL ((TLR_RESULT)0xC00C0062L)

//
// MessageId: TLR_E_PNIO_APCTL_TOO_MUCH_IO_DATA_CONFIGURED
//
// MessageText:
//
//  The maximum supported IO-data size is exceeded.
//
#define TLR_E_PNIO_APCTL_TOO_MUCH_IO_DATA_CONFIGURED ((TLR_RESULT)0xC00C0063L)

//
// MessageId: TLR_E_PNIO_APCTL_INVALID_IP_ADDRESS
//
// MessageText:
//
//  The IP address is invalid.
//
#define TLR_E_PNIO_APCTL_INVALID_IP_ADDRESS ((TLR_RESULT)0xC00C0064L)

//
// MessageId: TLR_E_PNIO_APCTL_INVALID_NETMASK
//
// MessageText:
//
//  The Netmask is invalid.
//
#define TLR_E_PNIO_APCTL_INVALID_NETMASK ((TLR_RESULT)0xC00C0065L)

//
// MessageId: TLR_E_PNIO_APCTL_INVALID_GATEWAY
//
// MessageText:
//
//  The gateway address is invalid.
//
#define TLR_E_PNIO_APCTL_INVALID_GATEWAY ((TLR_RESULT)0xC00C0066L)

//
// MessageId: TLR_E_PNIO_APCTL_TOO_MUCH_DATA_REQUESTED
//
// MessageText:
//
//  The maximum supported data size for this service is exceeded.
//
#define TLR_E_PNIO_APCTL_TOO_MUCH_DATA_REQUESTED ((TLR_RESULT)0xC00C0067L)

//
// MessageId: TLR_E_PNIO_APCTL_CHANNEL_INIT_RUNNING
//
// MessageText:
//
//  The request can not be handled because a ChannelInit is currently running.
//
#define TLR_E_PNIO_APCTL_CHANNEL_INIT_RUNNING ((TLR_RESULT)0xC00C0068L)

//
// MessageId: TLR_E_PNIO_APCTL_SEND_CMCTL_CHANNEL_INIT_FAILED
//
// MessageText:
//
//  Internal sending of Channel Init to CMCTL failed.
//
#define TLR_E_PNIO_APCTL_SEND_CMCTL_CHANNEL_INIT_FAILED ((TLR_RESULT)0xC00C0069L)

//
// MessageId: TLR_E_PNIO_APCTL_SEND_APCFG_CHANNEL_INIT_FAILED
//
// MessageText:
//
//  Internal sending of Channel Init to APCFG failed.
//
#define TLR_E_PNIO_APCTL_SEND_APCFG_CHANNEL_INIT_FAILED ((TLR_RESULT)0xC00C006AL)

//
// MessageId: TLR_E_PNIO_APCTL_EMPTY_CONFIGURATION
//
// MessageText:
//
//  A configuration without IO-Devices has been detected.
//
#define TLR_E_PNIO_APCTL_EMPTY_CONFIGURATION ((TLR_RESULT)0xC00C006BL)

/////////////////////////////////////////////////////////////////////////////////////
// PNIO APCFG Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_PNIO_APCFG_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command.
//
#define TLR_E_PNIO_APCFG_COMMAND_INVALID ((TLR_RESULT)0xC0140001L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_UNKNOWN_VERSION
//
// MessageText:
//
//  Unknown DBM version.
//
#define TLR_E_PNIO_APCFG_DBM_UNKNOWN_VERSION ((TLR_RESULT)0xC0140002L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_NO_DATASET
//
// MessageText:
//
//  No dataset existing.
//
#define TLR_E_PNIO_APCFG_DBM_NO_DATASET  ((TLR_RESULT)0xC0140003L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_WRONG_SIZE_OF_DATASET
//
// MessageText:
//
//  Wrong size of DBM dataset.
//
#define TLR_E_PNIO_APCFG_DBM_WRONG_SIZE_OF_DATASET ((TLR_RESULT)0xC0140004L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_WRONG_LEN_TYPEOFSTATION
//
// MessageText:
//
//  Type of station is too large.
//
#define TLR_E_PNIO_APCFG_DBM_WRONG_LEN_TYPEOFSTATION ((TLR_RESULT)0xC0140005L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_WRONG_LEN_NAMEOFSTATION
//
// MessageText:
//
//  Name of station is too large.
//
#define TLR_E_PNIO_APCFG_DBM_WRONG_LEN_NAMEOFSTATION ((TLR_RESULT)0xC0140006L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_UNKNOWN_IOCR_KEY
//
// MessageText:
//
//  Unkwown IOCR relationship in submodule description.
//
#define TLR_E_PNIO_APCFG_DBM_UNKNOWN_IOCR_KEY ((TLR_RESULT)0xC0140007L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_IOCR_ALREADY_IN_USE
//
// MessageText:
//
//  IOCR is in use by another IO-Device.
//
#define TLR_E_PNIO_APCFG_DBM_IOCR_ALREADY_IN_USE ((TLR_RESULT)0xC0140008L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_WRONG_IOCR_IN_SUBMDESCR
//
// MessageText:
//
//  Wrong IO-Type of IOCR in submodule description.
//
#define TLR_E_PNIO_APCFG_DBM_WRONG_IOCR_IN_SUBMDESCR ((TLR_RESULT)0xC0140009L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_WRONG_DATALEN_IN_SUBMDESCR
//
// MessageText:
//
//  Wrong data length in submodule description.
//
#define TLR_E_PNIO_APCFG_DBM_WRONG_DATALEN_IN_SUBMDESCR ((TLR_RESULT)0xC014000AL)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_WRONG_DATADESCR_IN_SUBMDESCR
//
// MessageText:
//
//  Wrong IO-type in data description of the submodule description.
//
#define TLR_E_PNIO_APCFG_DBM_WRONG_DATADESCR_IN_SUBMDESCR ((TLR_RESULT)0xC014000BL)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_UNEXP_SUBMDESCR
//
// MessageText:
//
//  Unexpected submodule description.
//
#define TLR_E_PNIO_APCFG_DBM_UNEXP_SUBMDESCR ((TLR_RESULT)0xC014000CL)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_MISSING_SUBMDESCR
//
// MessageText:
//
//  Missing submodule description.
//
#define TLR_E_PNIO_APCFG_DBM_MISSING_SUBMDESCR ((TLR_RESULT)0xC014000DL)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_ASSERTION_FAILED
//
// MessageText:
//
//  Assertion failed.
//
#define TLR_E_PNIO_APCFG_DBM_ASSERTION_FAILED ((TLR_RESULT)0xC014000EL)

//
// MessageId: TLR_E_PNIO_APCFG_PKT_UNEXP_TREE_IDENTIFICATON
//
// MessageText:
//
//  Wrong sequence/numbering in the tree identification numbers.
//
#define TLR_E_PNIO_APCFG_PKT_UNEXP_TREE_IDENTIFICATON ((TLR_RESULT)0xC014000FL)

//
// MessageId: TLR_E_PNIO_APCFG_PKT_OVERWRITING_CONSISTING_DATA
//
// MessageText:
//
//  Addressed dataset is already existing and would be overwritten.
//
#define TLR_E_PNIO_APCFG_PKT_OVERWRITING_CONSISTING_DATA ((TLR_RESULT)0xC0140010L)

//
// MessageId: TLR_E_PNIO_APCFG_PKT_MISSING_IOCR
//
// MessageText:
//
//  Input or output IOCR of module is missing.
//
#define TLR_E_PNIO_APCFG_PKT_MISSING_IOCR ((TLR_RESULT)0xC0140011L)

//
// MessageId: TLR_E_PNIO_APCFG_PKT_WRONG_IO_TYPE_IN_IOCR
//
// MessageText:
//
//  Wrong input or output type in IOCR.
//
#define TLR_E_PNIO_APCFG_PKT_WRONG_IO_TYPE_IN_IOCR ((TLR_RESULT)0xC0140012L)

//
// MessageId: TLR_E_PNIO_APCFG_PKT_WRONG_SEQUENCE_OF_FRAGMENTED_PACKETS
//
// MessageText:
//
//  Wrong sequence of fragmented packets.
//
#define TLR_E_PNIO_APCFG_PKT_WRONG_SEQUENCE_OF_FRAGMENTED_PACKETS ((TLR_RESULT)0xC0140013L)

//
// MessageId: TLR_E_PNIO_APCFG_PKT_WRONG_FRAGMENT_IDENTIFIER
//
// MessageText:
//
//  Wrong fragment identifier in fragmented packets.
//
#define TLR_E_PNIO_APCFG_PKT_WRONG_FRAGMENT_IDENTIFIER ((TLR_RESULT)0xC0140014L)

//
// MessageId: TLR_E_PNIO_APCFG_PKT_CONFIGURATION_IS_ALREADY_DONE_VIA_DBM
//
// MessageText:
//
//  Configuration is already done via DBM configuration packets are not accepted.
//
#define TLR_E_PNIO_APCFG_PKT_CONFIGURATION_IS_ALREADY_DONE_VIA_DBM ((TLR_RESULT)0xC0140015L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_INCOMPLETE_CONFIGURATION
//
// MessageText:
//
//  Incomplete configuration - not all devices are fully developet until submodule descriptions.
//
#define TLR_E_PNIO_APCFG_DBM_INCOMPLETE_CONFIGURATION ((TLR_RESULT)0xC0140016L)

//
// MessageId: TLR_E_PNIO_APCFG_PKT_DOWNLOAD_ALREADY_FINISHED
//
// MessageText:
//
//  Paket download is already finished by download finish request.
//
#define TLR_E_PNIO_APCFG_PKT_DOWNLOAD_ALREADY_FINISHED ((TLR_RESULT)0xC0140017L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_UNEXP_NUMBER_OF_RECORDS_IN_PNIOC_TABLES
//
// MessageText:
//
//  More than one entry for one key was found in the tables of the fieldbus specific data.
//
#define TLR_E_PNIO_APCFG_DBM_UNEXP_NUMBER_OF_RECORDS_IN_PNIOC_TABLES ((TLR_RESULT)0xC0140018L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_UNEXP_SIGNAL_ATTRIBUT
//
// MessageText:
//
//  Unexpected parameter Signal_Attrib in SIGNALS table.
//
#define TLR_E_PNIO_APCFG_DBM_UNEXP_SIGNAL_ATTRIBUT ((TLR_RESULT)0xC0140019L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_IMPROPER_DPM_OFFSETS_AND_DATA_LENGTHS_IN_SIGNALS
//
// MessageText:
//
//  Improper DPM offset and data length in SIGNALS.
//
#define TLR_E_PNIO_APCFG_DBM_IMPROPER_DPM_OFFSETS_AND_DATA_LENGTHS_IN_SIGNALS ((TLR_RESULT)0xC014001AL)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_WRONG_TEST_DATA
//
// MessageText:
//
//  Wrong test data.
//
#define TLR_E_PNIO_APCFG_DBM_WRONG_TEST_DATA ((TLR_RESULT)0xC0140020L)

//
// MessageId: TLR_E_PNIO_APCFG_DBM_INVALID_IO_DEVICE_AMOUNT
//
// MessageText:
//
//  Too many IO-Devices are configured.
//
#define TLR_E_PNIO_APCFG_DBM_INVALID_IO_DEVICE_AMOUNT ((TLR_RESULT)0xC0140021L)

// standard error codes 
//
// MessageId: TLR_E_PNIO_APCFG_RESOURCE_OUT_OF_MEMORY
//
// MessageText:
//
//  Not enough memory available for current request.
//
#define TLR_E_PNIO_APCFG_RESOURCE_OUT_OF_MEMORY ((TLR_RESULT)0xC0140030L)

//
// MessageId: TLR_E_PNIO_APCFG_PACKET_SEND_FAILED
//
// MessageText:
//
//  Error while sending internal message to another task.
//
#define TLR_E_PNIO_APCFG_PACKET_SEND_FAILED ((TLR_RESULT)0xC0140031L)

//Packet configuration check error codes
//
// MessageId: TLR_E_PNIO_APCFG_INVALID_NAME_OF_STATION_LENGTH
//
// MessageText:
//
//  The length of parameter NameOfStation is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_NAME_OF_STATION_LENGTH ((TLR_RESULT)0xC0140040L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_NAME_OF_STATION_CHARACTER
//
// MessageText:
//
//  The NameOfStation contains an invalid character.
//
#define TLR_E_PNIO_APCFG_INVALID_NAME_OF_STATION_CHARACTER ((TLR_RESULT)0xC0140041L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_TYPE_OF_STATION_LENGTH
//
// MessageText:
//
//  The length of parameter TypeOfStation is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_TYPE_OF_STATION_LENGTH ((TLR_RESULT)0xC0140042L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_TYPE_OF_STATION_CHARACTER
//
// MessageText:
//
//  The TypeOfStation cintains an invalid character.
//
#define TLR_E_PNIO_APCFG_INVALID_TYPE_OF_STATION_CHARACTER ((TLR_RESULT)0xC0140043L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_SYSTEMFLAGS
//
// MessageText:
//
//  The parameter SystemFlags is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_SYSTEMFLAGS ((TLR_RESULT)0xC0140044L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_WATCHDOG_TIME
//
// MessageText:
//
//  The parameter WatchdogTime is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_WATCHDOG_TIME ((TLR_RESULT)0xC0140045L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_VENDORID
//
// MessageText:
//
//  The Parameter VendorID is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_VENDORID ((TLR_RESULT)0xC0140046L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_DEVICEID
//
// MessageText:
//
//  The parameter DeviceID is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_DEVICEID ((TLR_RESULT)0xC0140047L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IP_ADDRESS
//
// MessageText:
//
//  The IP-Address to use is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IP_ADDRESS ((TLR_RESULT)0xC0140048L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_NETMASK
//
// MessageText:
//
//  The NetworkMask to use is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_NETMASK ((TLR_RESULT)0xC0140049L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_GATEWAY
//
// MessageText:
//
//  The Gateway-Address to use is invalid or unreachable.
//
#define TLR_E_PNIO_APCFG_INVALID_GATEWAY ((TLR_RESULT)0xC014004AL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IP_FLAGS
//
// MessageText:
//
//  The parameter IPFlags is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IP_FLAGS ((TLR_RESULT)0xC014004BL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_NAME_OF_STATION_STARTLABEL
//
// MessageText:
//
//  The NameOfStation shall not start with - . or port-xyz.
//
#define TLR_E_PNIO_APCFG_INVALID_NAME_OF_STATION_STARTLABEL ((TLR_RESULT)0xC014004CL)

//
// MessageId: TLR_E_PNIO_APCFG_NAME_OF_STATION_LABEL_TOO_SHORT
//
// MessageText:
//
//  One label of NameOfStation is too short.
//
#define TLR_E_PNIO_APCFG_NAME_OF_STATION_LABEL_TOO_SHORT ((TLR_RESULT)0xC014004DL)

//
// MessageId: TLR_E_PNIO_APCFG_NAME_OF_STATION_LABEL_TOO_LONG
//
// MessageText:
//
//  One label of NameOfStation is too long.
//
#define TLR_E_PNIO_APCFG_NAME_OF_STATION_LABEL_TOO_LONG ((TLR_RESULT)0xC014004EL)

//
// MessageId: TLR_E_PNIO_APCFG_NAME_OF_STATION_TOO_MANY_LABELS
//
// MessageText:
//
//  The NameOfStation contains too many labels.
//
#define TLR_E_PNIO_APCFG_NAME_OF_STATION_TOO_MANY_LABELS ((TLR_RESULT)0xC014004FL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_RTA_RETRIES
//
// MessageText:
//
//  The parameter RTARetries is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_RTA_RETRIES ((TLR_RESULT)0xC0140050L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_RTA_TIMEOUT
//
// MessageText:
//
//  The parameter RTATimeout is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_RTA_TIMEOUT ((TLR_RESULT)0xC0140051L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_AR_PROPERTIES
//
// MessageText:
//
//  The parameter ARProperties is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_AR_PROPERTIES ((TLR_RESULT)0xC0140052L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_AR_TYPE
//
// MessageText:
//
//  The parameter ARType is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_AR_TYPE ((TLR_RESULT)0xC0140053L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_AR_UUID
//
// MessageText:
//
//  The parameter ARUUID is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_AR_UUID ((TLR_RESULT)0xC0140054L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_ALARMCR_PROPERTIES
//
// MessageText:
//
//  The parameter AlarmCRProperties is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_ALARMCR_PROPERTIES ((TLR_RESULT)0xC0140055L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_ALARMCR_TYPE
//
// MessageText:
//
//  The Parameter AlarmCRType is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_ALARMCR_TYPE ((TLR_RESULT)0xC0140056L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_MCAST_MAC
//
// MessageText:
//
//  The parameter MulticastMACAddress is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_MCAST_MAC ((TLR_RESULT)0xC0140060L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_FRAMESENDOFFSET
//
// MessageText:
//
//  The parameter FrameSendOffset is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_FRAMESENDOFFSET ((TLR_RESULT)0xC0140061L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOCR_PROPERTIES
//
// MessageText:
//
//  The parameter IOCRProperties is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IOCR_PROPERTIES ((TLR_RESULT)0xC0140062L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOCR_DATA_LENGTH
//
// MessageText:
//
//  The parameter IOCRDataLength is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IOCR_DATA_LENGTH ((TLR_RESULT)0xC0140063L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOCR_TYPE
//
// MessageText:
//
//  The parameter IOCRType is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IOCR_TYPE ((TLR_RESULT)0xC0140064L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_DATAHOLDFACTOR
//
// MessageText:
//
//  The parameter DataHoldFactor is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_DATAHOLDFACTOR ((TLR_RESULT)0xC0140065L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_WATCHDOGFACTOR
//
// MessageText:
//
//  The Parameter WatchdogFactor is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_WATCHDOGFACTOR ((TLR_RESULT)0xC0140066L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_SENDCLOCKFACTOR
//
// MessageText:
//
//  The parameter SendClockFactor is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_SENDCLOCKFACTOR ((TLR_RESULT)0xC0140067L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_REDUCTIONRATIO
//
// MessageText:
//
//  The parameter ReductionRatio is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_REDUCTIONRATIO ((TLR_RESULT)0xC0140068L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_PHASE
//
// MessageText:
//
//  The Parameter Phase is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_PHASE   ((TLR_RESULT)0xC0140069L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOCS_LENGTH
//
// MessageText:
//
//  The parameter IOCSLength is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IOCS_LENGTH ((TLR_RESULT)0xC0140070L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOPS_LENGTH
//
// MessageText:
//
//  The parameter IOPSLength is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IOPS_LENGTH ((TLR_RESULT)0xC0140071L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_DPM_OFFSET
//
// MessageText:
//
//  The parameter DPMOffset is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_DPM_OFFSET ((TLR_RESULT)0xC0140072L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_FRAME_OFFSET
//
// MessageText:
//
//  The parameter FrameOffset is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_FRAME_OFFSET ((TLR_RESULT)0xC0140073L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOCS_FRAME_OFFSET
//
// MessageText:
//
//  The parameter IOCSFrameOffset is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IOCS_FRAME_OFFSET ((TLR_RESULT)0xC0140074L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_SUBMODULE_DATA_LENGTH
//
// MessageText:
//
//  The parameter SubmoduleDataLength is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_SUBMODULE_DATA_LENGTH ((TLR_RESULT)0xC0140075L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_DATA_DESCRIPTION
//
// MessageText:
//
//  The Parameter DataDescription is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_DATA_DESCRIPTION ((TLR_RESULT)0xC0140076L)

//
// MessageId: TLR_E_PNIO_APCFG_OVERLAPPING_FRAMEOFFSET_DATA
//
// MessageText:
//
//  The frame offset to use for IO-Data is already in use by another submodule.
//
#define TLR_E_PNIO_APCFG_OVERLAPPING_FRAMEOFFSET_DATA ((TLR_RESULT)0xC0140077L)

//
// MessageId: TLR_E_PNIO_APCFG_OVERLAPPING_FRAMEOFFSET_IOCS
//
// MessageText:
//
//  The frame offset to use for the IOCS is already in use by another submodule.
//
#define TLR_E_PNIO_APCFG_OVERLAPPING_FRAMEOFFSET_IOCS ((TLR_RESULT)0xC0140078L)

//
// MessageId: TLR_E_PNIO_APCFG_OVERLAPPING_DPMOFFSET
//
// MessageText:
//
//  The DPM offset to use for IO-Data is already in use by another submodule.
//
#define TLR_E_PNIO_APCFG_OVERLAPPING_DPMOFFSET ((TLR_RESULT)0xC0140079L)

//
// MessageId: TLR_E_PNIO_APCFG_FRAMEOFFSET_OUTSIDE_DEFINED_IOCR
//
// MessageText:
//
//  The frame offset is bigger than the IOCR-length.
//
#define TLR_E_PNIO_APCFG_FRAMEOFFSET_OUTSIDE_DEFINED_IOCR ((TLR_RESULT)0xC014007AL)

//
// MessageId: TLR_E_PNIO_APCFG_IOCS_FRAMEOFFSET_OUTSIDE_DEFINED_IOCR
//
// MessageText:
//
//  The IOCS frame offset is bigger than the IOCR-length.
//
#define TLR_E_PNIO_APCFG_IOCS_FRAMEOFFSET_OUTSIDE_DEFINED_IOCR ((TLR_RESULT)0xC014007BL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOCR_PROD_ID
//
// MessageText:
//
//  The IOCRIdProd is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IOCR_PROD_ID ((TLR_RESULT)0xC014007CL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOCR_CONS_ID
//
// MessageText:
//
//  The IOCRICons is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IOCR_CONS_ID ((TLR_RESULT)0xC014007DL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_RECORD_LENGTH
//
// MessageText:
//
//  The record data length is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_RECORD_LENGTH ((TLR_RESULT)0xC014007EL)

//
// MessageId: TLR_E_PNIO_APCFG_DUPLICATE_ARUUID
//
// MessageText:
//
//  The ARUUID of this IO-Device is already in use by another IO-Device.
//
#define TLR_E_PNIO_APCFG_DUPLICATE_ARUUID ((TLR_RESULT)0xC014007FL)

//
// MessageId: TLR_E_PNIO_APCFG_MULTIPLE_CR_NOT_SUPPORTED
//
// MessageText:
//
//  The configuration packet contains more than 1 IOCR for the same direction which is not supported.
//
#define TLR_E_PNIO_APCFG_MULTIPLE_CR_NOT_SUPPORTED ((TLR_RESULT)0xC0140080L)

//
// MessageId: TLR_E_PNIO_APCFG_FAULTY_VERSION_TABLE
//
// MessageText:
//
//  The content of the version table in database is invalid.
//
#define TLR_E_PNIO_APCFG_FAULTY_VERSION_TABLE ((TLR_RESULT)0xC0140081L)

//
// MessageId: TLR_E_PNIO_APCFG_UNSUPPORTED_DATABASE_VERSION
//
// MessageText:
//
//  The version of database is unsupported.
//
#define TLR_E_PNIO_APCFG_UNSUPPORTED_DATABASE_VERSION ((TLR_RESULT)0xC0140082L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_MAUTYPE
//
// MessageText:
//
//  The MAUType is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_MAUTYPE ((TLR_RESULT)0xC0140083L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_SIGNAL_TYPE
//
// MessageText:
//
//  The signal type is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_SIGNAL_TYPE ((TLR_RESULT)0xC0140084L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_NO_INTF_SUBM
//
// MessageText:
//
//  The requested submodule is no Interface Submodule.
//
#define TLR_E_PNIO_APCFG_INVALID_NO_INTF_SUBM ((TLR_RESULT)0xC0140085L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_NO_PORT_SUBM
//
// MessageText:
//
//  The requested submodule is no Port Submodule.
//
#define TLR_E_PNIO_APCFG_INVALID_NO_PORT_SUBM ((TLR_RESULT)0xC0140086L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_STRUCTURE_VERSION
//
// MessageText:
//
//  The value of structure version is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_STRUCTURE_VERSION ((TLR_RESULT)0xC0140087L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_HELLO_MODE
//
// MessageText:
//
//  The Hello Mode is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_HELLO_MODE ((TLR_RESULT)0xC0140088L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_HELLO_RETRY
//
// MessageText:
//
//  The value of Hello Retry is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_HELLO_RETRY ((TLR_RESULT)0xC0140089L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_HELLO_INTERVAL
//
// MessageText:
//
//  The value of Hello Interval is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_HELLO_INTERVAL ((TLR_RESULT)0xC014008AL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_HELLO_DELAY
//
// MessageText:
//
//  The value of Hello Delay is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_HELLO_DELAY ((TLR_RESULT)0xC014008BL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_MRP_ROLE
//
// MessageText:
//
//  The value of MRP Role is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_MRP_ROLE ((TLR_RESULT)0xC014008CL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_ORDERID_LENGTH
//
// MessageText:
//
//  The OrderId length is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_ORDERID_LENGTH ((TLR_RESULT)0xC014008DL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOPS_OFFSET
//
// MessageText:
//
//  The requested IOPS offset does not address a byte although byte mode is requested or is outside valid DPM area.
//
#define TLR_E_PNIO_APCFG_INVALID_IOPS_OFFSET ((TLR_RESULT)0xC014008EL)

//
// MessageId: TLR_E_PNIO_APCFG_OVERLAPPING_IOPS_OFFSET
//
// MessageText:
//
//  The requested IOPS offset is already in use by another element (data or IOxS).
//
#define TLR_E_PNIO_APCFG_OVERLAPPING_IOPS_OFFSET ((TLR_RESULT)0xC014008FL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOPS_MODE
//
// MessageText:
//
//  The requested IOPS mode is invalid or not supported.
//
#define TLR_E_PNIO_APCFG_INVALID_IOPS_MODE ((TLR_RESULT)0xC0140090L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOCS_MODE
//
// MessageText:
//
//  The requested IOCS mode is invalid or not supported.
//
#define TLR_E_PNIO_APCFG_INVALID_IOCS_MODE ((TLR_RESULT)0xC0140091L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOPS_STARTOFFSET
//
// MessageText:
//
//  The requested IOPS area offset is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IOPS_STARTOFFSET ((TLR_RESULT)0xC0140092L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_IOCS_STARTOFFSET
//
// MessageText:
//
//  The requested IOCS area offset is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_IOCS_STARTOFFSET ((TLR_RESULT)0xC0140093L)

//
// MessageId: TLR_E_PNIO_APCFG_NO_VALID_CONFIG_DATABASE
//
// MessageText:
//
//  No valid config database was found.
//
#define TLR_E_PNIO_APCFG_NO_VALID_CONFIG_DATABASE ((TLR_RESULT)0xC0140094L)

//
// MessageId: TLR_E_PNIO_APCFG_NO_VALID_NWID_DATABASE
//
// MessageText:
//
//  No valid nwid database was found.
//
#define TLR_E_PNIO_APCFG_NO_VALID_NWID_DATABASE ((TLR_RESULT)0xC0140095L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_ACTIVE_BITLIST_OFFSET
//
// MessageText:
//
//  The requested bit list offset for active IO-Devices is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_ACTIVE_BITLIST_OFFSET ((TLR_RESULT)0xC0140096L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_CONFIG_BITLIST_OFFSET
//
// MessageText:
//
//  The requested bit list offset for configured IO-Devices is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_CONFIG_BITLIST_OFFSET ((TLR_RESULT)0xC0140097L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_FAULTY_BITLIST_OFFSET
//
// MessageText:
//
//  The requested bit list offset for faulty IO-Devices is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_FAULTY_BITLIST_OFFSET ((TLR_RESULT)0xC0140098L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_BITLIST_MODE
//
// MessageText:
//
//  Either all or no bitlist offsets can be set to automatic mode.
//
#define TLR_E_PNIO_APCFG_INVALID_BITLIST_MODE ((TLR_RESULT)0xC0140099L)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_SUBM_DESCR
//
// MessageText:
//
//  At least one IOxS interface is active which forces usage of extended submodule description packet.
//
#define TLR_E_PNIO_APCFG_INVALID_SUBM_DESCR ((TLR_RESULT)0xC014009AL)

//
// MessageId: TLR_E_PNIO_APCFG_VERSION_INFO_ALREADY_SET
//
// MessageText:
//
//  The version info has already been set. It can only be set exactly once after power cycle.
//
#define TLR_E_PNIO_APCFG_VERSION_INFO_ALREADY_SET ((TLR_RESULT)0xC014009BL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_SW_PREFIX
//
// MessageText:
//
//  The value of parameter bVersionPrefix is invalid.
//
#define TLR_E_PNIO_APCFG_INVALID_SW_PREFIX ((TLR_RESULT)0xC014009CL)

//
// MessageId: TLR_E_PNIO_APCFG_INVALID_VERSION_STRING_LENGTH
//
// MessageText:
//
//  The version string conducted of the different version parameters is to long.
//
#define TLR_E_PNIO_APCFG_INVALID_VERSION_STRING_LENGTH ((TLR_RESULT)0xC014009DL)




#endif  //__PNIO_APCTL_ERROR_H

